import pandas as pd  
import pickle 
from decision_company import read_csv_file, filter_by_value, fetch_index, convert_to_list

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Filter the clients with a history of late payments  
late_payments = filter_by_value(high_credit_long_duration, 'credit_history', 'delayed previously')  
  
# Extract the client IDs  
result = fetch_index(late_payments)  
  
# Convert the result to a list  
result_list = convert_to_list(result)  
  
print(result_list)  
pickle.dump(result_list,open("./ref_result/result_list_2.pkl","wb"))